/*
 * Decompiled with CFR 0.152.
 */
package us.nickfraction.oofmod.settings;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class Settings {
    private File soundsFolder;
    private File configFile;
    private File selectedSound;
    private String selectedSoundName;
    private boolean enabled;
    private float volume;

    public Settings() throws Exception {
        this.configFile = new File(Minecraft.func_71410_x().field_71412_D, "config/oofmod/config.cfg");
        this.soundsFolder = new File("config/oofmod/sounds");
        if (!this.soundsFolder.exists()) {
            this.soundsFolder.mkdirs();
        }
        this.selectedSoundName = "oof.wav";
        this.enabled = true;
        this.selectedSound = new File(this.soundsFolder.getPath() + "/" + this.selectedSoundName + ".wav");
        this.volume = -10.0f;
        this.downloadDefaultSound();
    }

    public void setSelectedSoundName(String soundName) {
        this.selectedSoundName = soundName;
        this.selectedSound = new File(this.soundsFolder.getPath() + "/" + this.selectedSoundName);
    }

    public ArrayList<File> getSounds() {
        ArrayList<File> result = new ArrayList<File>();
        for (File file : this.soundsFolder.listFiles()) {
            if (!file.getName().endsWith(".wav")) continue;
            result.add(file);
        }
        return result;
    }

    public File getSelectedSound() {
        return this.selectedSound;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public float getVolume() {
        return this.volume;
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    public void saveConfig() throws Exception {
        Configuration config = new Configuration(this.configFile);
        this.updateConfig(config, false);
        config.save();
    }

    public void loadConfig() throws Exception {
        Configuration config = new Configuration(this.configFile);
        config.load();
        this.updateConfig(config, true);
        config.save();
    }

    public void updateConfig(Configuration config, boolean load) throws Exception {
        Property prop = config.get("global", "enabled", true);
        if (load) {
            this.enabled = prop.getBoolean();
        } else {
            prop.set(this.enabled);
        }
        prop = config.get("global", "selectedsound", "oof.wav");
        if (load) {
            this.setSelectedSoundName(prop.getString());
            if (this.selectedSound.exists()) {
                AudioInputStream audioIn = AudioSystem.getAudioInputStream(this.selectedSound.toURI().toURL());
                Clip clip = AudioSystem.getClip();
                clip.open(audioIn);
            }
        } else {
            prop.set(this.selectedSoundName);
        }
        prop = config.get("global", "volume", 30.0);
        if (load) {
            this.volume = (float)prop.getDouble();
        } else {
            prop.set((double)this.volume);
        }
    }

    private void downloadDefaultSound() {
        File defaultSound = new File("config/oofmod/sounds/oof.wav");
        if (defaultSound.exists()) {
            return;
        }
        try {
            URL url = new URL("https://oofmodsound.powns.dev/");
            URLConnection con = url.openConnection();
            DataInputStream dis = new DataInputStream(con.getInputStream());
            byte[] fileData = new byte[con.getContentLength()];
            for (int q = 0; q < fileData.length; ++q) {
                fileData[q] = dis.readByte();
            }
            dis.close();
            FileOutputStream fos = new FileOutputStream(new File(this.soundsFolder.getPath() + "/oof.wav"));
            fos.write(fileData);
            fos.close();
        }
        catch (Exception m) {
            System.out.println(m);
        }
    }
}

